
### onBeforeFormulaInsertion
**onBeforeFormulaInsertion** event is triggered before a formula is inserted. Admits a *wrs_PluginEvent* object with the following arguments:
* mathml: MathML generated by MathType.
* editMode (read only): indicates if the MathType output is an image (editMode=image) or if the MathType output is LaTeX (editMode=latex).
* language: MathType language.

#### Examlple
In this example the MathML generated by MathType is replaced by a fixed one:
```javascript
wrs_addPluginListener({'onBeforeFormulaInsertion': function(params) {
    params.mathml = '<math xmlns="http://www.w3.org/1998/Math/MathML"><msqrt><mi>x</mi></msqrt></math>'
}})
```
### onAfterFormulaInsertion
**onAfterFormulaInsertion** event is triggered after a formula is inserted. Admits an *wrs_PluginEvent* object with the following arguments:
* editMode (read only): indicates if MathType output is an image (editMode=image) or if MathType output is LaTeX (editMode=latex)
* node: contains the image object generated by MathType (editMode=image).
* latex: contains the LaTeX code generated by MathType (editMode=latex).

In this example the image object created by MathType is logged:
```javascript
wrs_addPluginListener({'onAfterFormulaInsertion' : function(params){
    console.log(node);
}});
```